﻿namespace Microsoft.Samples.PlanMyNight.Web
{
    using System.Web.Mvc;
    using System.Web.Routing;

    public static class RoutingManager
    {
        public static void RegisterRoutes(RouteCollection routes)
        {
            routes.IgnoreRoute("SiteMaster/{*pathInfo}");

            routes.IgnoreRoute("{resource}.axd/{*pathInfo}");

            routes.IgnoreRoute("JsCombine.ashx/{*pathInfo}");

            routes.MapRoute(
               "ItineraryDetails",
               "Itineraries/{id}",
               new { controller = "Itineraries", action = "Details" },
               new { id = @"^\d+$" });

            routes.MapRoute(
                "Default",                                                                // Route name
                "{controller}/{action}/{id}",                                             // URL with parameters
                new { controller = "Search", action = "Index", id = string.Empty });      // Parameter defaults
        }
    }
}
